// gworld.h

#define kBlobHorizSize 24
#define kBlobVertSize 24
#define kBlobShadowDepth 6
#define kBlobShadowError 2

#define kBlastWidth 72
#define kBlastHeight 72
#define kBlastFrames 14

void GetBlobGraphics( void );
void InitGWorld( GWorldPtr *world, const Rect *worldSize, int depth );
void PrepareForGDrawing( GWorldPtr world );
void FinishGDrawing( GWorldPtr world );
void InitPlayerWorlds( void );
void DrawBlob( int player, Rect *myRect, int Blob, int state, int charred );
void DrawSprite( Rect *myRect, int Blob, int state );
void DrawPictInGWorld( GWorldPtr gWorld, int pictID );
void DrawPictInPort( CGrafPtr port, int pictID );
void DrawBoard( int player, Rect *myRect );
void MakePictRes( GWorldPtr world, Str255 defaultName, short resID ); 
void DrawShadow( Rect *myRect, int Blob, int state );
void DrawAlpha( Rect *myRect, int Blob, int mask, int state );
void DrawColor( Rect *myRect, int Blob, int state, int r, int g, int b, int w );

extern GWorldPtr blobWorld, maskWorld, blastWorld, blastMaskWorld, boardWorld[2], playerWorld[2], playerSpriteWorld[2];
extern int gLevel;

#define kMaxGLevel 10